/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.util;

public class StringUtils {
    public static final String BULLET = "\u2022 ";
    public static final String EMPTY = "";
    public static final String LINE_DELIMITER = System.getProperty("line.separator", "\r\n");

    public static String trimBrackets(String stringToTrim) {
        if (stringToTrim == null) {
            return null;
        }
        String trimmed = stringToTrim.trim();
        if (trimmed.startsWith("[")) {
            trimmed = trimmed.substring(1);
        }
        if (trimmed.endsWith("]")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static String formatAsPlainText(String text) {
        String tempText = StringUtils.stripCarriageReturns(text);
        tempText = StringUtils.stripWhitespace(tempText);
        tempText = StringUtils.replace(tempText, "</li>", EMPTY);
        tempText = StringUtils.replace(tempText, "<li>", String.valueOf(LINE_DELIMITER) + "\t" + BULLET);
        tempText = StringUtils.replace(tempText, "<p>", LINE_DELIMITER);
        tempText = StringUtils.stripHTML(tempText);
        return tempText.trim();
    }

    public static String stripHTML(String text) {
        if (text == null) {
            return null;
        }
        String tempText = text.replaceAll("<p>", "\n");
        return tempText.replaceAll("\\<.*?\\>", EMPTY);
    }

    public static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String stripWhitespace(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\s+", " ");
    }

    public static String stripCarriageReturns(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\n", EMPTY);
    }

    public static String trimStringQuotes(String str) {
        char endChar;
        if (str == null || str.length() < 2) {
            return str;
        }
        int stringStart = 0;
        int end = str.length() - 1;
        char startChar = str.charAt(stringStart);
        if (startChar == (endChar = str.charAt(end)) && startChar == '\'' || startChar == '\"') {
            return str.substring(1, end - 1);
        }
        return str;
    }
}

